-- Maintenance on the tech_results table:
--  Update the simqual field to use "None" instead of "NA".
--  Delete duplicated records by removing the older one.
--  Delete duplicated records that have the same timestamp by 
--    removing one of them.
-- Note: it is (much) faster to add records to the tech_results table without primary keys
--       and then delete the duplicates than it is to add records via Update with primary keys 
-- Fix the sim qualifier:
UPDATE tech_results SET simqual = 'None' WHERE simqual = 'NA';
-- Find duplicates and delete the older one:
DELETE FROM tech_results USING tech_results t2
  WHERE tech_results.techrefid = t2.techrefid 
    AND tech_results.simqual = t2.simqual
    AND tech_results.bldgtype = t2.bldgtype
    AND tech_results.bldgvint = t2.bldgvint
    AND tech_results.bldgloc = t2.bldgloc
    AND tech_results.bldghvac = t2.bldghvac
    AND tech_results.tstat = t2.tstat
    AND tech_results.lastmod < t2.lastmod;
-- Find duplicates that have the same value for lastmod and delete one:
DELETE FROM tech_results 
    WHERE EXISTS
(SELECT 1 from tech_results t2 where 
       t2.techrefid = tech_results.techrefid and
       t2.simqual   = tech_results.simqual and
       t2.bldgtype  = tech_results.bldgtype and
       t2.bldgvint  = tech_results.bldgvint and
       t2.bldgloc   = tech_results.bldgloc and
       t2.bldghvac  = tech_results.bldghvac and
       t2.tstat     = tech_results.tstat and
       t2.ctid > tech_results.ctid);